/*
 * Decompiled with CFR 0.152.
 */
package emulator.unittest.hardware;

import emulator.hardware.HwByte;
import org.junit.Assert;
import org.junit.Test;

public class HwByteTest {
    @Test
    public void testInit() {
        HwByte b = new HwByte();
        Assert.assertEquals((long)0L, (long)b.getNumber());
    }

    @Test
    public void testAdd() {
        HwByte b = new HwByte();
        b.add(HwByte.create(127));
        Assert.assertEquals((long)127L, (long)b.getNumber());
        b.add(HwByte.create(128));
        Assert.assertEquals((long)255L, (long)b.getNumber());
        b.add(HwByte.create(1));
        Assert.assertEquals((long)0L, (long)b.getNumber());
    }

    @Test
    public void testSub() {
        HwByte b = new HwByte();
        b.sub(HwByte.create(127));
        Assert.assertEquals((long)129L, (long)b.getNumber());
        b.sub(HwByte.create(128));
        Assert.assertEquals((long)1L, (long)b.getNumber());
        b.sub(HwByte.create(1));
        Assert.assertEquals((long)0L, (long)b.getNumber());
    }

    @Test
    public void testMul() {
        HwByte b = new HwByte();
        b.mul(HwByte.create(1));
        Assert.assertEquals((long)0L, (long)b.getNumber());
        b.setNumber(21L);
        b.mul(HwByte.create(0));
        Assert.assertEquals((long)0L, (long)b.getNumber());
        b.setNumber(21L);
        b.mul(HwByte.create(3));
        Assert.assertEquals((long)63L, (long)b.getNumber());
        b.mul(HwByte.create(16));
        Assert.assertEquals((long)240L, (long)b.getNumber());
    }

    @Test
    public void testDiv() {
        HwByte b = new HwByte();
        b.div(HwByte.create(1));
        Assert.assertEquals((long)0L, (long)b.getNumber());
        b.setNumber(165L);
        b.div(HwByte.create(62));
        Assert.assertEquals((long)2L, (long)b.getNumber());
        b.div(HwByte.create(2));
        Assert.assertEquals((long)1L, (long)b.getNumber());
        b.div(HwByte.create(2));
        Assert.assertEquals((long)0L, (long)b.getNumber());
    }

    @Test(expected=ArithmeticException.class)
    public void testDivZero() {
        HwByte b = new HwByte();
        b.setNumber(21L);
        b.div(HwByte.create(0));
        Assert.assertEquals((long)0L, (long)b.getNumber());
    }

    @Test
    public void testNot() {
        HwByte b = new HwByte();
        b.not();
        Assert.assertEquals((long)255L, (long)b.getNumber());
    }

    @Test
    public void testAnd() {
        HwByte b = new HwByte();
        b.setNumber(62L);
        b.and(HwByte.create(17));
        Assert.assertEquals((long)16L, (long)b.getNumber());
    }

    @Test
    public void testOr() {
        HwByte b = new HwByte();
        b.setNumber(62L);
        b.or(HwByte.create(17));
        Assert.assertEquals((long)63L, (long)b.getNumber());
    }

    @Test
    public void testXor() {
        HwByte b = new HwByte();
        b.setNumber(62L);
        b.xor(HwByte.create(17));
        Assert.assertEquals((long)47L, (long)b.getNumber());
    }

    @Test
    public void testShift() {
        HwByte b = new HwByte();
        b.shift(5);
        Assert.assertEquals((long)0L, (long)b.getNumber());
        b.setNumber(50L);
        b.shift(0);
        Assert.assertEquals((long)50L, (long)b.getNumber());
        b.shift(2);
        Assert.assertEquals((long)200L, (long)b.getNumber());
        b.shift(-4);
        Assert.assertEquals((long)12L, (long)b.getNumber());
        b.shift(5);
        Assert.assertEquals((long)128L, (long)b.getNumber());
    }

    @Test
    public void testIsGreaterThan() {
        HwByte b = new HwByte();
        Assert.assertFalse((boolean)b.isGreaterThan(HwByte.create(127)));
        Assert.assertFalse((boolean)b.isGreaterThan(HwByte.create(147)));
        b.setNumber(127L);
        Assert.assertFalse((boolean)b.isGreaterThan(HwByte.create(127)));
        Assert.assertFalse((boolean)b.isGreaterThan(HwByte.create(147)));
        b.setNumber(128L);
        Assert.assertTrue((boolean)b.isGreaterThan(HwByte.create(127)));
        Assert.assertFalse((boolean)b.isGreaterThan(HwByte.create(147)));
        b.setNumber(175L);
        Assert.assertTrue((boolean)b.isGreaterThan(HwByte.create(127)));
        Assert.assertTrue((boolean)b.isGreaterThan(HwByte.create(147)));
    }

    @Test
    public void testIsEqualTo() {
        HwByte b = new HwByte();
        b.setNumber(3L);
        Assert.assertFalse((boolean)b.isEqualTo(HwByte.create(0)));
        Assert.assertTrue((boolean)b.isEqualTo(HwByte.create(3)));
        Assert.assertFalse((boolean)b.isEqualTo(HwByte.create(127)));
    }

    @Test
    public void testIsLessThan() {
        HwByte b = new HwByte();
        Assert.assertTrue((boolean)b.isLessThan(HwByte.create(127)));
        Assert.assertTrue((boolean)b.isLessThan(HwByte.create(147)));
        b.setNumber(127L);
        Assert.assertFalse((boolean)b.isLessThan(HwByte.create(127)));
        Assert.assertTrue((boolean)b.isLessThan(HwByte.create(147)));
        b.setNumber(128L);
        Assert.assertFalse((boolean)b.isLessThan(HwByte.create(127)));
        Assert.assertTrue((boolean)b.isLessThan(HwByte.create(147)));
        b.setNumber(175L);
        Assert.assertFalse((boolean)b.isLessThan(HwByte.create(127)));
        Assert.assertFalse((boolean)b.isLessThan(HwByte.create(147)));
    }

    @Test
    public void testSetBit() {
        HwByte b = new HwByte();
        b.setBit(0, true);
        Assert.assertEquals((long)1L, (long)b.getNumber());
        b.setBit(5, true);
        Assert.assertEquals((long)33L, (long)b.getNumber());
        b.setBit(0, false);
        Assert.assertEquals((long)32L, (long)b.getNumber());
    }

    @Test
    public void testGetBit() {
        HwByte b = new HwByte(55L);
        Assert.assertTrue((boolean)b.getBit(0));
        Assert.assertTrue((boolean)b.getBit(1));
        Assert.assertTrue((boolean)b.getBit(2));
        Assert.assertFalse((boolean)b.getBit(3));
        Assert.assertTrue((boolean)b.getBit(4));
        Assert.assertTrue((boolean)b.getBit(5));
        Assert.assertFalse((boolean)b.getBit(6));
        Assert.assertFalse((boolean)b.getBit(7));
        Assert.assertFalse((boolean)b.getBit(8));
    }
}

